
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;


public abstract class Gamer {
	protected int score, cardNumber;
	protected boolean burstFlag;
    protected BGControler m_Controler;
    protected ArrayList<Integer> m_cardNoList;
    protected int px, py;
	
	public Gamer(BGControler controler){
         m_Controler = controler;
		score = 0;
		burstFlag = false;
        px=py=0;

       m_cardNoList = new ArrayList<Integer>();
	}

    public ArrayList<Integer> getCardList(){
        return m_cardNoList;
    }

    public void repair(){
        score=0;
		burstFlag = false;

        m_cardNoList.clear();
    }

    public int getScore(){
        return score;
    }

    public int getCardNum(){
        return cardNumber;
    }

	public abstract boolean checkHitEnable();

	public void drawGamer(Graphics g){
        g.setColor(new Color(0, 190, 230));
        g.fillRect(px, py + 3, 150, 150);
        
        //g.setColor(new Color(0, 190, 230));
        g.drawRect(px+10, py + 13, 150, 150);

    }

    public void setBounds(int x0, int y0){
        px=x0; py=y0;
    }

	public void Hit(){
		cardNumber = (int)Math.ceil(Math.random() * 13);
		m_cardNoList.add(cardNumber);

		if(cardNumber == 1){
            if(score + 11 < 21){
                score += 11;
            }else{
                cardNumber +=1;
            }

		}else if(1 < cardNumber && cardNumber < 10){
			score += cardNumber;
		}else{
			score += 10;
		}
		
		
		if(score >= 21){
			burstFlag=true;
		}
		
	}
	
	public void Stand(){
		
	}
		
	
}
