
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;



public class BGControler implements ActionListener{

    private Gamer g1, g2;
    private BGPanel m_Panel;
    private String infoStr = null;
    private boolean board_flag = false;
    private boolean hit_dealer_flag = false;
    private Timer infoBoardTimer;
    private JLabel lblBoard;
    private int gameCounter;

    public BGControler(BGPanel panel){
        g1 = new Dealer(this);
        g2 = new Player(this);
        m_Panel = panel;

        lblBoard = new JLabel();
        lblBoard.setOpaque(true);
        lblBoard.setBackground(Color.lightGray);
        lblBoard.setBorder(new BevelBorder(BevelBorder.RAISED, Color.white, Color.black));
        lblBoard.setVisible(false);

        panel.setLayout(null);
        panel.add(lblBoard);

        infoBoardTimer = new Timer(1500, this);
        gameCounter = 0;

        g1.setBounds(75, 20);
        g2.setBounds(75, 330);

        startNextGame();
        
    }

   public void setHitDealerEvent(boolean flag){
       hit_dealer_flag=flag;
   }

    public void doDealerTurn(){
        if(g1.checkHitEnable()){
            g1.Hit();
            
            showInfoBoard("<html>Dealer Turn<br />Card Number : " + g1.getCardNum()+ "!!</html>");
        }
    }

    public void startNextGame(){
        gameCounter++;

        g1.repair();
        g2.repair();

        getActivePlayer().doBet(50);
        g1.Hit(); g1.Hit();
        g2.Hit(); g2.Hit();
        
        updateBoardGraphic();
        lblBoard.setVisible(false);

        if(g2.getScore() == 21 || g1.getScore() == 21){
            showNextGameInfo();
        }
    }

    public void updateBoardGraphic(){
        m_Panel.repaint();
    }

    public void showInfoBoard(String str){
        infoStr = str;
        board_flag = true;
        updateBoardGraphic();

        infoBoardTimer.start();
    }

    public void showNextGameInfo(){
        int dealer_s = g1.getScore();
        int player_s = g2.getScore();
        ArrayList<Integer> cardList = null;
        StringBuilder str = new StringBuilder();

        //Dealer Info
        str.append("<html><body><h2>#" + gameCounter + " round#</h2><h1>Dealer</h1>[Cards]<br />");
        cardList = g1.getCardList();
        for(int i1=0; i1 < cardList.size(); i1++){
            str.append(cardList.get(i1)); str.append("  ");
        }
        str.append("<br />Total :");
        str.append(g1.getScore());

        //Player Info
        str.append("<br /><h1>Player</h1>[Cards] <br /> ");
        cardList = g2.getCardList();
        for(int i1=0; i1 < cardList.size(); i1++){
            str.append(cardList.get(i1)); str.append(" ");
        }
        str.append("<br /> Total :");
        str.append(g2.getScore());
        str.append("<br /><b>");

        if(player_s <= 21 && dealer_s <= 21 && player_s == dealer_s){
            str.append("Push!!");
            getActivePlayer().addMoney(getActivePlayer().getBet());

        }else if(player_s == 21){
            str.append("You're a winer!!");
             getActivePlayer().addMoney(getActivePlayer().getBet() * 2);

        }else if(player_s > 21){
            str.append("Burst!! You're a loser (> <)v");

        }else if(player_s < 21){
            if(player_s < dealer_s && dealer_s <= 21){
                str.append("You're a loser.");

             }else if(player_s > dealer_s || dealer_s > 21){
                str.append("You're a winer!!");
                getActivePlayer().addMoney(getActivePlayer().getBet() * 2);
             }
        }
        
        str.append("</b></body></html>");

        int str_x = m_Panel.getWidth()/2 - 150;
        int str_y = m_Panel.getHeight()/2 - 140;

        lblBoard.setText(str.toString());
        lblBoard.setBounds(str_x, str_y, 300, 280);
        lblBoard.setVisible(true);
        updateBoardGraphic();

    }

    public Player getActivePlayer(){
        return (Player)g2;
    }

    public Dealer getActiveDealer(){
        return (Dealer)g1;
    }

   public void updateGamerGraphics(Graphics g){
        g1.drawGamer(g);
        g2.drawGamer(g);

        if(board_flag){
            int str_x = m_Panel.getWidth()/2 - 100;
            int str_y = m_Panel.getHeight()/2 - 100;

            lblBoard.setBounds(str_x, str_y, 200, 200);
            lblBoard.setText(infoStr);
            lblBoard.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
       if(e.getSource().equals(infoBoardTimer)){
           board_flag = false;
           lblBoard.setVisible(false);
           updateBoardGraphic();
           infoBoardTimer.stop();

           if(hit_dealer_flag){
               doDealerTurn();
               hit_dealer_flag = false;
           }
       }
    }
}
