
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BGControlPanel extends JPanel implements ActionListener{
    private JButton btnExit;
    private JButton btnStand;
    private JButton btnHit;
    private JButton btnNext;
    private JButton btnInfo;
    private BGControler m_Controler;

    public BGControlPanel(BGControler controler){
        m_Controler = controler;

        btnHit = new JButton("Hit");
        btnHit.addActionListener(this);
        btnHit.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        btnStand = new JButton("Stand");
        btnStand.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        btnStand.addActionListener(this);
        btnNext = new JButton("Next Game");
        btnNext.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        btnNext.addActionListener(this);
        btnInfo = new JButton("Information");
        btnInfo.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        btnInfo.addActionListener(this);
        btnExit = new JButton("Quit");
        btnExit.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        btnExit.addActionListener(this);

        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        this.add(btnHit);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.add(btnStand);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.add(btnNext);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.add(btnInfo);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.add(btnExit);
    }

    public void updateControlPanelEnable(){
        Player player = m_Controler.getActivePlayer();

        if(!player.checkHitEnable()){
            btnHit.setEnabled(false);
            btnStand.setEnabled(false);
        }else{

        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();

        if(obj.equals(btnExit)){
            System.exit(0);

        }else if(obj.equals(btnHit)){
            
            Player player = m_Controler.getActivePlayer();
            player.Hit();
            
            if(!player.checkHitEnable()){
                Dealer dealer = m_Controler.getActiveDealer();

                while(dealer.checkHitEnable()){
                    dealer.Hit();
                    m_Controler.updateBoardGraphic();
                }

                m_Controler.showNextGameInfo();

            }else{
                m_Controler.setHitDealerEvent(true);
                m_Controler.showInfoBoard("<html>Player Turn<br />Card Number : " + player.getCardNum()+ "!!</html>");
                
            }
            updateControlPanelEnable();

            
        }else if(obj.equals(btnStand)){
            Dealer dealer = m_Controler.getActiveDealer();

            btnHit.setEnabled(false);
            btnStand.setEnabled(false);
            while(dealer.checkHitEnable()){
               dealer.Hit();
               m_Controler.updateBoardGraphic();
            }

            m_Controler.showNextGameInfo();

        }else if(obj.equals(btnNext)){
             m_Controler.startNextGame();

            btnHit.setEnabled(true);
            btnStand.setEnabled(true);
            
        }else if(obj.equals(btnInfo)){
            JOptionPane.showMessageDialog(this, "Black Jack Ver1.0\nauthor : Kawai Yuta");
        }

    }
}
